Option Explicit

'  1. ʼ 
Dim objFSO, objShell, objNetwork, objWMIService
Dim objExcel, wbSalary, wbSheBao, wbAccount, objNewBook, ws
Dim strCurrentDir, strScriptName
Dim strSalaryFile, strAccountFile, strSheBaoFile, strExportFile
Dim strBfPath, strCurrentDateTime, strBfFolderName
Dim oFolder, oFiles, file, bSalaryFound, bSheBaoExists
Dim colPrinters, objPrinter, colDefPrinters

' 
Set objFSO = CreateObject("Scripting.FileSystemObject")
Set objShell = CreateObject("WScript.Shell")
Set objNetwork = CreateObject("WScript.Network")

' ȡ·
strCurrentDir = objShell.CurrentDirectory
strScriptName = WScript.ScriptName
strSalaryFile = strCurrentDir & "\ʱ.xlsx"
strAccountFile = strCurrentDir & "\ʱ.xlsx"
strSheBaoFile = strCurrentDir & "\籣δ걨Ϣ.xls"
strExportFile = strCurrentDir & "\յ.xlsx"

'  2. ļԤ 
Set oFolder = objFSO.GetFolder(strCurrentDir)
Set oFiles = oFolder.Files
bSalaryFound = False

If objFSO.FileExists(strSalaryFile) Then
    bSalaryFound = True
Else
    For Each file In oFiles
        If file.Name <> strScriptName And InStr(file.Name, "ʱ") > 0 Then
            file.Name = "ʱ.xlsx"
            bSalaryFound = True
            Exit For
        End If
    Next
End If

If Not bSalaryFound Then
    MsgBox "뽫ʱ뵱ǰļ", 16, ""
    WScript.Quit
End If

If Not objFSO.FileExists(strAccountFile) Then
    MsgBox "ȱٺļ: ʱ.xlsx", 16, ""
    WScript.Quit
End If

bSheBaoExists = objFSO.FileExists(strSheBaoFile)

'  3. ٴӡ 
On Error Resume Next
objNetwork.SetDefaultPrinter "DM1005"
If Err.Number <> 0 Then
    Err.Clear
    Set objWMIService = GetObject("winmgmts:\\.\root\cimv2")
    Set colPrinters = objWMIService.ExecQuery("Select * From Win32_Printer Where Name = 'DM1005'")
    If colPrinters.Count = 0 Then
        Set colDefPrinters = objWMIService.ExecQuery("Select * From Win32_Printer Where Default = True")
        For Each objPrinter in colDefPrinters
            objPrinter.RenamePrinter("DM1005")
        Next
    End If
    objNetwork.SetDefaultPrinter "DM1005"
End If
On Error GoTo 0

'  4. ׼· 
strBfFolderName = ""
strCurrentDateTime = Year(Now) & Right("0" & Month(Now), 2) & Right("0" & Day(Now), 2) & _
                     Right("0" & Hour(Now), 2) & Right("0" & Minute(Now), 2)
strBfPath = strCurrentDir & "\" & strCurrentDateTime & "-" & strBfFolderName & "\"

If bSheBaoExists Then
    If Not objFSO.FolderExists(strBfPath) Then objFSO.CreateFolder strBfPath
End If

'  5. Excel ٺ 
Set objExcel = CreateObject("Excel.Application")
objExcel.Visible = False
objExcel.DisplayAlerts = False
objExcel.ScreenUpdating = False 

' >>>  A: ļ
Set wbSalary = objExcel.Workbooks.Open(strSalaryFile)
If bSheBaoExists Then
    Set wbSheBao = objExcel.Workbooks.Open(strSheBaoFile)
End If
Set wbAccount = objExcel.Workbooks.Open(strAccountFile)

' >>>  B: ݸ뵼
If bSheBaoExists Then
    ' 1. 
    On Error Resume Next
    Set ws = wbAccount.Sheets("")
    If Err.Number = 0 Then
        ws.Range("A2").CurrentRegion.Copy
        Set objNewBook = objExcel.Workbooks.Add
        objNewBook.Sheets(1).Range("A1").PasteSpecial -4163
        If objFSO.FileExists(strExportFile) Then objFSO.DeleteFile strExportFile
        objNewBook.SaveAs strExportFile
        objNewBook.Close False
    End If
    On Error GoTo 0
    
    ' 2. дڵƾ֤
    WriteDateToPZ wbAccount
    
    ' 3. 
    wbAccount.Save
End If

' >>>  C: ӡ 
' (ǿ + Ϊ1ҳ)

' ӡʱ (ʹ 512 ֽ +  + 1ҳ)
PrintSheetCustomSize wbSalary, "ְ"
If SheetExists(wbSalary, "Ų") Then PrintSheetCustomSize wbSalary, "Ų"

' ӡʱ
PrintSheetCustomSize wbAccount, "ݷ"
PrintSheet wbAccount, "Զ", 0, True
PrintSheet wbAccount, "Ż", 0, True
If bSheBaoExists Then PrintSheet wbAccount, "һ", 0, True

' >>>  D: רñ
If bSheBaoExists Then
    Dim strAccBackupDest
    strAccBackupDest = strBfPath & "ʱ_" & strCurrentDateTime & ".xlsx"
    ' ñݺ
    BackupSpecialAccountInMemory wbAccount, strAccBackupDest
End If

' >>>  E: رļ
wbAccount.Close False
If bSheBaoExists Then wbSheBao.Close False
wbSalary.Close True

objExcel.Quit
Set objExcel = Nothing

'  6.  DTZ ļ 
Dim colDTZFiles, objDTZ
Set colDTZFiles = objFSO.GetFolder(strCurrentDir).Files
For Each objDTZ In colDTZFiles
    If LCase(objFSO.GetExtensionName(objDTZ)) = "dtz" And InStr(objDTZ.Name, "ʱ") > 0 Then
        objShell.Run Chr(34) & objDTZ.Path & Chr(34)
        Exit For
    End If
Next

'  7. ʣļ/ƶ 
If bSheBaoExists Then
    DoFileCleanupProcess strBfPath, strCurrentDateTime
    MsgBox "ȫܴɣ" & vbCrLf & "ӡ" & vbCrLf & "ţеΪһҳ", 64, "ɹ"
Else
    MsgBox "ӡ (δ⵽籣ļ)", 64, ""
End If


' 
'             ӳ
' 

Sub WriteDateToPZ(wb)
    On Error Resume Next
    Dim ws, dtLastDay
    dtLastDay = DateSerial(Year(Date), Month(Date) + 1, 0)
    Set ws = wb.Sheets("ƾ֤")
    If Err.Number = 0 Then
        ws.Range("A2:A47").Value = dtLastDay
        ws.Range("A2:A47").NumberFormat = "yyyy-m-d"
    End If
    On Error GoTo 0
End Sub

' ڴ汸ݣֵи߱
Sub BackupSpecialAccountInMemory(wbSource, destPath)
    Dim objEx, wbNew, wsSrc, wsNew
    Set objEx = wbSource.Application 
    
    On Error Resume Next
    Set wbNew = objEx.Workbooks.Add
    
    ' 1. ѭб
    For Each wsSrc In wbSource.Worksheets
        Set wsNew = wbNew.Worksheets.Add(, wbNew.Worksheets(wbNew.Worksheets.Count))
        wsNew.Name = wsSrc.Name
        
        ' ֵ
        wsSrc.UsedRange.Copy
        wsNew.Range("A1").PasteSpecial -4163 ' xlPasteValues
        
        ' ضǿʹиƸʽԱи
        If wsSrc.Name = "ƾ֤" Or wsSrc.Name = "ƾ֤" Then
            wsSrc.Rows.Copy ' 
            wsNew.Range("A1").PasteSpecial -4122 ' xlPasteFormats
        Else
            wsNew.Range("A1").PasteSpecial -4122 
        End If
        
        wsNew.Range("A1").PasteSpecial 8 ' xlPasteColumnWidths
        
        objEx.CutCopyMode = False
        wsNew.Range("A1").Select
    Next
    
    ' 2. ɾĬɵĿ Sheet1
    Dim ws, bFound, wsCheck
    For Each ws In wbNew.Worksheets
        bFound = False
        For Each wsCheck In wbSource.Worksheets
            If ws.Name = wsCheck.Name Then 
                bFound = True
                Exit For
            End If
        Next
        If Not bFound Then ws.Delete
    Next
    
    ' ǿƽƾ֤ƶһλ
    If SheetExists(wbNew, "ƾ֤") Then
        wbNew.Sheets("ƾ֤").Move wbNew.Sheets(1)
    End If
    
    wbNew.SaveAs destPath, 51
    wbNew.Close False
    On Error GoTo 0
End Sub

' ļӾѱ˲߼
Sub DoFileCleanupProcess(bfPath, timeStamp)
    Dim strWhitelist, arrWhitelist
    Dim file, strBaseName, strExt, strNewFileName, strDestPath, i, bIsWhitelisted
    
    strWhitelist = "ʱ.xlsx,ʱ.dtz,ѱ.xlsx,ѱ.dtz,2ֻ.vbs,5ɾѱ˵.vbs,˺.xlsx"
    strWhitelist = strWhitelist & "," & strScriptName
    arrWhitelist = Split(strWhitelist, ",")
    
    Set oFiles = objFSO.GetFolder(strCurrentDir).Files
    
    For Each file In oFiles
        If InStr(file.Path, bfPath) = 0 Then
            If LCase(file.Name) <> "ʱ.xlsx" Then
                
                bIsWhitelisted = False
                For Each i In arrWhitelist
                    If LCase(file.Name) = LCase(i) Then
                        bIsWhitelisted = True
                        Exit For
                    End If
                Next
                
                strBaseName = objFSO.GetBaseName(file.Name)
                strExt = LCase(objFSO.GetExtensionName(file.Name))
                If strExt <> "" Then
                    strNewFileName = strBaseName & "_" & timeStamp & "." & strExt
                Else
                    strNewFileName = strBaseName & "_" & timeStamp
                End If
                strDestPath = bfPath & strNewFileName
                
                ' ųݵļ
                Dim bSkipBackup
                bSkipBackup = False
                If strExt = "vbs" Then bSkipBackup = True
                If LCase(file.Name) = "ʱ.dtz" Then bSkipBackup = True
                If InStr(LCase(file.Name), "ѱ") > 0 Then bSkipBackup = True
                
                If Not bSkipBackup Then
                    On Error Resume Next
                    If bIsWhitelisted Then
                        file.Copy strDestPath, True
                    Else
                        file.Move strDestPath
                    End If
                    On Error GoTo 0
                End If
            End If
        End If
    Next
End Sub

Function SheetExists(wb, strName)
    Dim ws
    On Error Resume Next
    Set ws = wb.Sheets(strName)
    If Err.Number = 0 Then SheetExists = True Else SheetExists = False
    On Error GoTo 0
End Function

Sub PrintSheet(wb, sheetName, paperSizeCode, bSimplePrint)
    On Error Resume Next
    Dim ws
    Set ws = wb.Sheets(sheetName)
    If Err.Number <> 0 Then Exit Sub
    If Not bSimplePrint Then
        With ws.PageSetup
            .Orientation = 1
            If paperSizeCode <> 0 Then .PaperSize = paperSizeCode
            .Zoom = False
            .FitToPagesWide = 1
            .FitToPagesTall = False
        End With
    End If
    ws.PrintOut
    On Error GoTo 0
End Sub

' صԶߴ +  + еΪһҳ
Sub PrintSheetCustomSize(wb, sheetName)
    On Error Resume Next
    Dim ws
    Set ws = wb.Sheets(sheetName)
    If Err.Number <> 0 Then Exit Sub
    
    With ws.PageSetup
        ' 1. ôӡΪ (xlPortrait = 1)
        .Orientation = 1
        
        ' 2. ԶֽŴС
        .PaperSize = 512 
        
        ' 3. ýеΪһҳ (ͬExcel: 1ҳ߶Զ)
        .Zoom = False            ' Ƚù̶
        .FitToPagesWide = 1      ' ǿƿΪ 1 ҳ
        .FitToPagesTall = False  ' ߶Ȳ (Ϊ False ʾԶ)
        
        ' ӡ򣬷ֹӡȫ
        .PrintArea = ""
    End With
    
    ws.PrintOut
    On Error GoTo 0
End Sub